const mongoose = require('mongoose');

const tempUserSchema = new mongoose.Schema({
    name: { type: String, required: true },
    email: { type: String, required: true, unique: true },
    phone: { type: String, required: true, unique: true },
    address: { type: String }, // Optional, only for labour
    password: { type: String, required: true }, // Hashed password
    userType: { type: String, required: true, enum: ['customer', 'labour'] },
    
    // Labour-specific fields (optional)
    labourType: [{ type: String }],
    profilePic: { type: String },
    cnicPic: { type: String },
    policeCertPic: { type: String },
    
    // Verification fields
    verificationToken: { type: String, required: true },
    tokenExpires: { type: Date, required: true },
}, { timestamps: true });

// Set token to expire after 1 hour automatically
tempUserSchema.index({ createdAt: 1 }, { expireAfterSeconds: 3600 });

module.exports = mongoose.model('TempUser', tempUserSchema);