const express = require('express');
const router = express.Router();
const paymentController = require('../controllers/paymentController');
const { protectLabour } = require('../middleware/authMiddleware'); // Import your middleware

// Route to get all pending payments for the authenticated labourer
// This route should only be accessible by the authenticated labourer themselves.
router.get('/labourer/pending', protectLabour, paymentController.getPendingPaymentsForLabourer);

// Route to get all cleared (completed) payments for the authenticated labourer
// This route should also only be accessible by the authenticated labourer.
router.get('/labourer/cleared', protectLabour, paymentController.getClearedPaymentsForLabourer);

module.exports = router; // Make sure this line is present and correct!