// models/WorkOrder.js
const mongoose = require('mongoose');

const workOrderSchema = new mongoose.Schema({
  labourerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Labor',
    required: true
  },
  customerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Customer'
  },
  customerName: {
    type: String,
    required: true
  },
  customerPhone: {
    type: String,
    required: true
  },
  customerEmail: {
    type: String
  },
  workDescription: {
    type: String,
    required: true
  },
  customerLocation: {
    lat: Number,
    lng: Number
  },
  requiredLaborType: {
    type: String,
    required: true
  },
  status: {
    type: String,
    enum: ['pending', 'accepted', 'rejected', 'completed'],
    default: 'pending'
  },
  createdAt: {
    type: Date,
    default: Date.now
  },
  requestExpiresAt: {
    type: Date,
    required: true
  },
  // --- NEW FIELDS FOR RATING AND REVIEW ---
  rating: {
    type: Number,
    min: 1,
    max: 5,
    
  },
  reviewComment: {
    type: String,
    trim: true,
    
  }
});

module.exports = mongoose.model('WorkOrder', workOrderSchema);