const express = require('express');
const router = express.Router();
const workOrderController = require('../controllers/workOrderController');
const { protectLabour,protect } = require('../middleware/authMiddleware');

// Add this route
router.get('/my-orders', protectLabour, workOrderController.getLabourerOrders);

// Other routes...
router.post('/', protect, workOrderController.requestWork);
router.put('/:orderId/status', protectLabour, workOrderController.updateOrderStatus);
// Change from POST to PUT and make endpoint plural to match frontend
router.put('/:orderId/reviews', protect, workOrderController.addReview);
router.get('/customer-orders', protect, workOrderController.getCustomerOrders);

module.exports = router;