// utils/emailTemplates.js

/**
 * Generates a stylish HTML email body.
 * @param {object} options - The options for the email content.
 * @param {string} options.title - The main headline of the email.
 * @param {string} options.name - The recipient's name.
 * @param {string} options.message - The main paragraph of the email.
 * @param {string} [options.buttonUrl] - Optional URL for a call-to-action button.
 * @param {string} [options.buttonText] - Optional text for the button.
 * @returns {string} The full HTML for the email body.
 */
exports.generateEmailHTML = ({ title, name, message, buttonUrl, buttonText }) => {
    const appName = 'laborPK';
    
    return `
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body { font-family: Arial, sans-serif; margin: 0; padding: 0; background-color: #f4f4f4; }
            .container { max-width: 600px; margin: 20px auto; background-color: #ffffff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
            .header { background-color: #2a6df5; color: #ffffff; padding: 20px; text-align: center; }
            .header h1 { margin: 0; font-size: 24px; }
            .content { padding: 30px; color: #333333; line-height: 1.6; }
            .content h2 { color: #2a6df5; }
            .button-container { text-align: center; margin-top: 20px; }
            .button { background-color: #2a6df5; color: #ffffff; padding: 12px 25px; text-decoration: none; border-radius: 5px; font-weight: bold; display: inline-block; }
            .footer { background-color: #f9f9f9; padding: 20px; text-align: center; font-size: 12px; color: #777777; border-top: 1px solid #dddddd; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>${appName}</h1>
            </div>
            <div class="content">
                <h2 style="font-size: 20px;">Hello, ${name}!</h2>
                <p>${message}</p>
                ${buttonUrl && buttonText ? `
                <div class="button-container">
                    <a href="${buttonUrl}" class="button">${buttonText}</a>
                </div>
                ` : ''}
            </div>
            <div class="footer">
                <p>&copy; ${new Date().getFullYear()} ${appName}. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    `;
};